<?php
/**
 * XenForo Add-on Merge Double User Post
 *
 * @category XenForo Add-on
 * @package    XfRu_MergeDoubleUserPost
 * @copyright  Copyright (c) 2010 XF-Russia. (http://www.xf-russia.ru)
 * @license
 * @version   $Id: CleanUp.php 59 2010-12-17 22:45:41Z pepelac $ $Date: 2010-12-17 23:45:41 +0100 (Fri, 17 Dec 2010) $ $Revision: 59 $
 * @author Pepelac
 *
 */

class XfRu_MergeDoubleUserPost_Model_CleanUp extends XenForo_Model_Post
{
	public function __construct()
	{
		parent::__construct();
	}

	public function replaceMergetimeTag($isUninstall = false)
	{
		$options = XenForo_Application::get('options');

		if (!$options->XfRu_DPP_ReplaceTag) return false;

		$startTime = $this->getCleanUpStartTime();
	    $endTime = ($isUninstall) ? 0 : $this->getCleanUpStopTime();

	    $posts = $this->getPostsToClean($startTime, $endTime);

	    $regex = '/\[MERGETIME="(\d*)"\]\[\/MERGETIME\]/i';

		foreach ($posts AS $postId => &$post)
		{
			if (preg_match_all($regex, $post['message'], $matches))
			{
				$post['message'] = preg_replace_callback($regex, array($this, 'replaceTag'), $post['message']);

				$dw = XenForo_DataWriter::create('XenForo_DataWriter_DiscussionMessage_Post');
				$dw->setOption(XenForo_DataWriter_DiscussionMessage::OPTION_IS_AUTOMATED, true);
				$dw->setExistingData($post['post_id'], true);
				$dw->set('message', $post['message']);
				$dw->save();
			} else {
				unset($posts[$postId]);
			}
		}
	}

	public function updateLastRunTime()
	{
		$this->_getDb()->query("
			UPDATE xfr_cronjob SET last_run = ? WHERE addon_id = ? AND job_id = ?",
			array('last_run' => XenForo_Application::$time, 'addon_id' => 'XfRuMergeDoubleUserPost', 'job_id' => 'xfr_dpp_cleanup')
		);
	}

	private function replaceTag($matches)
	{
		$options = XenForo_Application::get('options');
	    
		if ($options->XfRu_DPP_TagReplacement == 'spacer')
		{
			$spacer = '[COLOR=rgb('.$this->hex2RGB($options->XfRu_DPP_Timestamp_Spacer_Color, true).')]'
				. '[SIZE='.$options->XfRu_DPP_Timestamp_Spacer_Fontsize.']' . $options->XfRu_DPP_Timestamp_Spacer_Text
				. '[/SIZE][/COLOR]';
			$replacement = sprintf($spacer, XenForo_Template_Helper_Core::dateTime($matches[1], 'absolute'));
		} else {
			$replacement = PHP_EOL;
		}
		return $replacement;
	}

	private function getCleanUpStartTime()
	{
		$lastCleanUp = $this->_getDb()->fetchOne(
			"SELECT last_run FROM xfr_cronjob WHERE addon_id = ? AND job_id = ?",
			array('addon_id' => 'XfRuMergeDoubleUserPost', 'job_id' => 'xfr_dpp_cleanup')
		);
		
		return $lastCleanUp;
	}

	private function getCleanUpStopTime()
	{
		// get back to 7 days
		return XenForo_Application::$time - (3600 * 24 * 7);
	}

	private function getPostsToClean($startTime, $endTime)
	{
		$limitOptions = $this->prepareLimitFetchOptions(array());

		$startTime = ($startTime) ? " AND post_date >= ".$startTime : "";
		$endTime = ($endTime) ? " AND post_date <= ".$endTime : "";

		$sql = $this->limitQueryResults("
			SELECT post.*
			FROM xf_post AS post
			WHERE post.message LIKE " . XenForo_Db::quoteLike('[MERGETIME', 'lr') . $startTime . $endTime . "
			ORDER BY post.post_id
		", $limitOptions['limit'], $limitOptions['offset']);

		return $this->fetchAllKeyed($sql, 'post_id');
	}

	private function hex2RGB($hexStr, $returnAsString = false, $seperator = ',')
	{
		$hexStr = preg_replace("/[^0-9A-Fa-f]/", '', $hexStr); // Gets a proper hex string
		$rgbArray = array();
		if (strlen($hexStr) == 6)
		{ //If a proper hex code, convert using bitwise operation. No overhead... faster
			$colorVal = hexdec($hexStr);
			$rgbArray['red'] = 0xFF & ($colorVal >> 0x10);
			$rgbArray['green'] = 0xFF & ($colorVal >> 0x8);
			$rgbArray['blue'] = 0xFF & $colorVal;
		} elseif (strlen($hexStr) == 3) { //if shorthand notation, need some string manipulations
			$rgbArray['red'] = hexdec(str_repeat(substr($hexStr, 0, 1), 2));
			$rgbArray['green'] = hexdec(str_repeat(substr($hexStr, 1, 1), 2));
			$rgbArray['blue'] = hexdec(str_repeat(substr($hexStr, 2, 1), 2));
		} else {
			return false; //Invalid hex color code
		}
        return $returnAsString ? implode($seperator, $rgbArray) : $rgbArray; // returns the rgb string or the associative array
	}
}